/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.PreferencesChangeEvent;
import com.xmlmind.guiutil.PreferencesChangeListener;
import com.xmlmind.guiutil.PreferencesSheet;
import com.xmlmind.guiutil.PreferencesSheetPane;
import com.xmlmind.util.Preferences;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PreferencesEditor
extends JPanel
implements TreeSelectionListener {
    private HashMap<String, PreferencesSheet> nameToSheet;
    private boolean setTreeSize;
    private JTree sheetTree;
    private JLabel sheetTitle;
    private JScrollPane sheetScroller;
    private Preferences preferences = null;
    private boolean selectingSheet = false;
    private PreferencesSheet selectedSheet = null;

    public PreferencesEditor() {
        this.setLayout(DialogUtil.pxBorderLayout(5, 5));
        this.nameToSheet = new HashMap();
        this.setTreeSize = false;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        this.sheetTree = new JTree(defaultMutableTreeNode);
        this.sheetTree.setEditable(false);
        this.sheetTree.setRootVisible(false);
        this.sheetTree.setShowsRootHandles(true);
        DialogUtil.adjustRowHeight(this.sheetTree, 0);
        this.sheetTree.setToggleClickCount(2);
        this.sheetTree.getSelectionModel().setSelectionMode(1);
        this.sheetTree.addTreeSelectionListener(this);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.sheetTree.setCellRenderer(defaultTreeCellRenderer);
        JScrollPane jScrollPane = DialogUtil.createScrollPane(this.sheetTree);
        this.add((Component)jScrollPane, "West");
        JPanel jPanel = new JPanel(DialogUtil.pxBorderLayout(5, 5));
        this.add((Component)jPanel, "Center");
        this.sheetTitle = new JLabel();
        this.sheetTitle.setOpaque(true);
        this.sheetTitle.setHorizontalAlignment(2);
        this.sheetTitle.setFont(AWTUtil.pxDeriveFont(this.sheetTitle.getFont(), 1, 4));
        this.sheetTitle.setBackground(AWTUtil.toDarkShadowColor(this.getBackground()));
        this.sheetTitle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), DialogUtil.pxEmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)this.sheetTitle, "North");
        this.sheetScroller = new JScrollPane();
        DialogUtil.configureScrollPane(this.sheetScroller);
        jPanel.add((Component)this.sheetScroller, "Center");
        this.sheetScroller.getViewport().setBackground(jPanel.getBackground());
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.selectingSheet) {
            this.select(treeSelectionEvent.getPath());
        }
    }

    public boolean addSheet(PreferencesSheet preferencesSheet, String string) {
        String string2 = preferencesSheet.getName();
        if (this.nameToSheet.containsKey(string2)) {
            return false;
        }
        this.nameToSheet.put(string2, preferencesSheet);
        preferencesSheet.editor = this;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        if (string != null) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement();
                PreferencesSheet preferencesSheet2 = (PreferencesSheet)defaultMutableTreeNode3.getUserObject();
                if (preferencesSheet2 == null || !string.equals(preferencesSheet2.getName())) continue;
                defaultMutableTreeNode = defaultMutableTreeNode3;
                break;
            }
        }
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(preferencesSheet));
        this.setTreeSize = true;
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.setTreeSize) {
            this.setTreeSize = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.sheetTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
            }
            this.sheetTree.setPreferredSize(this.sheetTree.getPreferredSize());
        }
        return super.getPreferredSize();
    }

    public boolean containsSheet(String string) {
        return this.nameToSheet.containsKey(string);
    }

    public PreferencesSheet getSheet(String string) {
        return this.nameToSheet.get(string);
    }

    public PreferencesSheet[] getSheets() {
        PreferencesSheet[] preferencesSheetArray = new PreferencesSheet[this.nameToSheet.size()];
        this.nameToSheet.values().toArray(preferencesSheetArray);
        return preferencesSheetArray;
    }

    public void setSelectedSheet(PreferencesSheet preferencesSheet) {
        TreePath treePath = null;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            PreferencesSheet preferencesSheet2 = (PreferencesSheet)defaultMutableTreeNode2.getUserObject();
            if (preferencesSheet2 != preferencesSheet) continue;
            treePath = new TreePath(defaultMutableTreeNode2.getPath());
            break;
        }
        if (treePath != null) {
            this.select(treePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void select(TreePath treePath) {
        PreferencesSheetPane preferencesSheetPane;
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        PreferencesSheet preferencesSheet = (PreferencesSheet)defaultMutableTreeNode.getUserObject();
        if (preferencesSheet.pane == null) {
            serializable = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                preferencesSheetPane = preferencesSheet.getPane();
            }
            finally {
                this.setCursor((Cursor)serializable);
            }
        } else {
            preferencesSheetPane = preferencesSheet.pane;
        }
        if (this.preferences != null && !preferencesSheet.filled) {
            preferencesSheet.filled = true;
            preferencesSheet.fillPane(this.preferences);
        }
        this.selectedSheet = preferencesSheet;
        this.selectingSheet = true;
        this.sheetTree.setSelectionPath(treePath);
        this.selectingSheet = false;
        this.sheetTree.scrollPathToVisible(treePath);
        this.sheetTitle.setText(preferencesSheet.getLabel());
        serializable = this.sheetScroller.getViewport();
        ((JViewport)serializable).setView(preferencesSheetPane);
        ((JViewport)serializable).scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public PreferencesSheet getSelectedSheet() {
        return this.selectedSheet;
    }

    public void addPreferencesChangeListener(PreferencesChangeListener preferencesChangeListener) {
        this.listenerList.add(PreferencesChangeListener.class, preferencesChangeListener);
    }

    public void removePreferencesChangeListener(PreferencesChangeListener preferencesChangeListener) {
        this.listenerList.remove(PreferencesChangeListener.class, preferencesChangeListener);
    }

    public void edit(Preferences preferences) {
        if (this.nameToSheet.size() == 0) {
            return;
        }
        this.preferences = preferences;
        for (PreferencesSheet object : this.nameToSheet.values()) {
            object.filled = false;
        }
        if (this.selectedSheet == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getFirstChild();
            this.selectedSheet = (PreferencesSheet)defaultMutableTreeNode2.getUserObject();
        }
        this.setSelectedSheet(this.selectedSheet);
    }

    public boolean commit() {
        PreferencesChangeEvent preferencesChangeEvent = new PreferencesChangeEvent(this, this.preferences);
        boolean bl = true;
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.sheetTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            PreferencesSheet preferencesSheet = (PreferencesSheet)defaultMutableTreeNode2.getUserObject();
            if (preferencesSheet == null || !preferencesSheet.filled) continue;
            Preferences preferences = new Preferences();
            if (!preferencesSheet.validatePane(preferences)) {
                bl = false;
                break;
            }
            if (!PreferencesEditor.checkChanges(this.preferences, preferences)) continue;
            preferencesChangeEvent.addChange(preferencesSheet.getName(), preferences);
            bl2 = true;
        }
        if (bl && bl2) {
            this.firePreferencesChange(preferencesChangeEvent);
        }
        return bl;
    }

    private static final boolean checkChanges(Preferences preferences, Preferences preferences2) {
        boolean bl = false;
        String[] stringArray = preferences2.getAll();
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i + 1];
            String string2 = stringArray[i];
            String string3 = preferences.getString(string2, null);
            if (!string.equals(string3)) {
                bl = true;
                continue;
            }
            preferences2.remove(string2);
        }
        return bl;
    }

    private void firePreferencesChange(PreferencesChangeEvent preferencesChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PreferencesChangeListener.class) continue;
            ((PreferencesChangeListener)objectArray[i + 1]).preferencesChange(preferencesChangeEvent);
        }
    }
}

