/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.IconResource;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class MenuIcon
implements Icon {
    public final Icon clientIcon;
    public final int clientIconWidth;
    public final int clientIconHeight;
    public final Icon clientDisabledIcon;
    private int menuWidth;
    private int menuHeight;
    private int menuGap;

    public MenuIcon(Icon icon) {
        this.clientIcon = icon;
        this.clientIconWidth = icon.getIconWidth();
        this.clientIconHeight = icon.getIconHeight();
        this.clientDisabledIcon = IconResource.createDisabledIcon(icon, null);
        if (this.clientIconHeight < 16) {
            this.menuWidth = 5;
            this.menuHeight = 3;
        } else if (this.clientIconHeight < 24) {
            this.menuWidth = 7;
            this.menuHeight = 4;
        } else if (this.clientIconHeight < 32) {
            this.menuWidth = 9;
            this.menuHeight = 5;
        } else if (this.clientIconHeight < 48) {
            this.menuWidth = 11;
            this.menuHeight = 6;
        } else if (this.clientIconHeight < 64) {
            this.menuWidth = 13;
            this.menuHeight = 7;
        } else {
            this.menuWidth = 15;
            this.menuHeight = 8;
        }
        this.menuGap = (this.menuWidth + 3) / 4;
    }

    @Override
    public int getIconWidth() {
        return this.clientIconWidth + 2 * this.menuGap + this.menuWidth;
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.clientIconHeight, this.menuHeight);
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        boolean bl = !component.isEnabled();
        Icon icon = bl ? this.clientDisabledIcon : this.clientIcon;
        icon.paintIcon(component, graphics, n, n2);
        graphics.setColor(bl ? AWTUtil.convertToGray(component.getBackground(), -0.25f, true) : component.getForeground());
        int n3 = (n += this.clientIconWidth + this.menuGap) + this.menuWidth - 1;
        int n4 = (n2 += (this.clientIconHeight - this.menuHeight + 1) / 2) + this.menuHeight - 1;
        while (n2 <= n4) {
            graphics.drawLine(n, n2, n3, n2);
            ++n;
            --n3;
            ++n2;
        }
    }
}

