/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.HintLabel;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.util.XMLText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;

public class LinkButton
extends JLabel {
    protected EventListenerList actionListeners = new EventListenerList();
    protected String actionCommand = null;
    protected static IconResource stockIcon;

    public LinkButton(String string, Icon icon) {
        StringBuilder stringBuilder = new StringBuilder("<html><span style='color: ");
        stringBuilder.append(AWTUtil.toHexString(HintLabel.getHintForeground()));
        stringBuilder.append("; text-decoration: underline;'>");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</span>");
        this.setText(stringBuilder.toString());
        if (icon != null) {
            this.setIcon(icon);
            IconResource.setDisabledIcon(this, icon);
            this.setIconTextGap(4);
            this.setHorizontalAlignment(10);
            this.setHorizontalTextPosition(4);
            this.setVerticalTextPosition(0);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (LinkButton.this.isEnabled() && mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 1) {
                    ActionEvent actionEvent = new ActionEvent(LinkButton.this, 1001, LinkButton.this.actionCommand);
                    LinkButton.this.fireActionPerformed(actionEvent);
                }
            }
        });
    }

    public static Icon getStockIcon() {
        if (stockIcon == null) {
            stockIcon = new IconResource(LinkButton.class, "linkButton.png");
        }
        return stockIcon;
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.actionListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(ActionListener.class, actionListener);
    }
}

