/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.AWTUtil;
import com.xmlmind.guiutil.Msg;
import com.xmlmind.util.Log;
import com.xmlmind.util.Preferences;
import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.html.HTMLEditorKit;

public final class InitLAF {
    private static boolean initialized;
    private static Integer htmlFontSize;

    private InitLAF() {
    }

    public static void init(Preferences preferences, String string) {
        int n;
        String string2;
        if (initialized) {
            return;
        }
        initialized = true;
        if (preferences == null) {
            preferences = new Preferences();
        }
        if ("-".equals(string2 = preferences.getString("lookAndFeelClassName", "-")) || "default".equals(string2)) {
            string2 = InitLAF.defaultLAFName();
        } else if ("system".equals(string2)) {
            string2 = InitLAF.fallbackLAFName();
        }
        ArrayList<Object> arrayList = null;
        if (string2 != null && (string2 = string2.trim()).length() > 0 && string2.endsWith("]") && (n = string2.indexOf(91)) > 0) {
            String string3 = string2.substring(n + 1, string2.length() - 1);
            string2 = string2.substring(0, n).trim();
            arrayList = new ArrayList<Object>();
            InitLAF.parseLAFCustomization(string3, arrayList);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = InitLAF.fallbackLAFName();
            arrayList = null;
            preferences.putString("lookAndFeelClassName", "system");
        }
        n = AWTUtil.setDisplayScaling(preferences.getInt("displayScaling", 100, 400, -1));
        boolean bl = false;
        boolean bl2 = false;
        if (arrayList != null) {
            bl = InitLAF.applyLAFCustomization(true, arrayList, n);
        }
        boolean bl3 = false;
        try {
            UIManager.setLookAndFeel(string2);
            if (arrayList != null) {
                bl2 = InitLAF.applyLAFCustomization(false, arrayList, n);
            }
            bl3 = true;
        }
        catch (Exception exception) {
            InitLAF.logError(string, string2, exception);
        }
        if (!bl3) {
            string2 = InitLAF.fallbackLAFName();
            arrayList = null;
            bl2 = false;
            bl = false;
            preferences.putString("lookAndFeelClassName", "system");
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception) {
                InitLAF.logError(string, string2, exception);
            }
        }
        if (!bl && !bl2) {
            InitLAF.applyDisplayScaling(string2, n);
        }
        InitLAF.configureHTMLContent(-1);
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    private static String defaultLAFName() {
        if (SystemUtil.IS_GENERIC_UNIX) {
            String string = "com.formdev.flatlaf.FlatLightLaf";
            try {
                Class.forName(string);
                return string + "[-Dflatlaf.uiScale=${XXE.displayScalingFactor}\n-Dflatlaf.menuBarEmbedded=false]";
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return InitLAF.fallbackLAFName();
    }

    private static String fallbackLAFName() {
        if (SystemUtil.IS_GENERIC_UNIX) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    private static void parseLAFCustomization(String string, List<Object> list) {
        String[] stringArray;
        for (String string2 : stringArray = StringUtil.split(string, '\n')) {
            Object object;
            int n;
            if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || (n = string2.indexOf(61)) <= 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            int n2 = string3.length();
            if (string3.startsWith("-D")) {
                n2 -= 2;
            }
            int n3 = string4.length();
            if (n2 <= 0 || n3 <= 0) continue;
            Object object2 = null;
            if ("true".equals(string4)) {
                object2 = Boolean.TRUE;
            } else if ("false".equals(string4)) {
                object2 = Boolean.FALSE;
            } else if (n3 >= 2 && string4.charAt(0) == '\"' && string4.charAt(n3 - 1) == '\"') {
                object2 = string4.substring(1, n3 - 1);
            } else if (string4.charAt(0) == '#') {
                object2 = AWTUtil.fromHexString(string4);
            } else if (string4.startsWith("Insets(") && string4.endsWith(")")) {
                object = StringUtil.split(string4.substring(7, n3 - 1), ',');
                if (((String[])object).length == 4) {
                    try {
                        int n4 = Integer.parseInt(((String)object[0]).trim());
                        int n5 = Integer.parseInt(((String)object[1]).trim());
                        int n6 = Integer.parseInt(((String)object[2]).trim());
                        int n7 = Integer.parseInt(((String)object[3]).trim());
                        object2 = new Insets(n4, n5, n6, n7);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (string4.startsWith("${") && string4.endsWith("}")) {
                object = string4.substring(2, n3 - 1).trim();
                if (((String)object).length() > 0) {
                    object2 = new StringBuilder((String)object);
                }
            } else {
                try {
                    object2 = Integer.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (object2 == null) continue;
            list.add(string3);
            list.add(object2);
        }
    }

    private static boolean applyLAFCustomization(boolean bl, List<Object> list, int n) {
        boolean bl2 = false;
        int n2 = list.size();
        for (int i = 0; i < n2; i += 2) {
            String string = (String)list.get(i);
            Object object = list.get(i + 1);
            boolean bl3 = false;
            if (object instanceof StringBuilder) {
                String string2 = ((StringBuilder)object).toString();
                if (!"XXE.displayScalingFactor".equals(string2) || n < 100) continue;
                object = (double)n / 100.0;
                bl3 = true;
            }
            if (string.startsWith("-D")) {
                if (!bl) continue;
                string = string.substring(2);
                System.setProperty(string, object.toString());
                if (!bl3) continue;
                bl2 = true;
                continue;
            }
            if (bl) continue;
            UIManager.put(string, object);
            if (!bl3) continue;
            bl2 = true;
        }
        return bl2;
    }

    private static void logError(String string, String string2, Exception exception) {
        if (string != null) {
            Log.getLog(string).error(Msg.msg("cannotSetLAF", string2, ThrowableUtil.detailedReason(exception)));
        }
    }

    private static void applyDisplayScaling(String string, int n) {
        Font font;
        int n2;
        Serializable serializable;
        String[] stringArray;
        int n3 = AWTUtil.px(12);
        int n4 = -1;
        if (n > 100 && n != AWTUtil.getSystemDisplayScaling()) {
            n4 = n3;
        } else if (!SystemUtil.IS_MAC_OS && (stringArray = UIManager.getFont("Button.font")) != null && stringArray.getSize() < n3) {
            n4 = n3;
        }
        stringArray = null;
        if (n4 >= 8 && n4 <= 72 && (serializable = UIManager.getFont("Button.font")) != null && (n2 = n4 - ((Font)serializable).getSize()) != 0) {
            for (String string2 : stringArray = InitLAF.getUIPropertyNames()) {
                serializable = UIManager.getFont(string2);
                if (serializable == null) continue;
                FontUIResource object = new FontUIResource(((Font)serializable).getFamily(), ((Font)serializable).getStyle(), ((Font)serializable).getSize() + n2);
                UIManager.put(string2, object);
            }
        }
        if (n > 100) {
            int n5;
            serializable = UIManager.getInsets("Menu.margin");
            Font font2 = UIManager.getFont("Menu.font");
            if (serializable != null && font2 != null && (((Insets)serializable).left < (n5 = font2.getSize() / 4) || ((Insets)serializable).right < n5)) {
                InsetsUIResource insetsUIResource = new InsetsUIResource(((Insets)serializable).top, n5, ((Insets)serializable).bottom, n5);
                UIManager.put("Menu.margin", insetsUIResource);
            }
        }
        boolean bl = string.equals(UIManager.getSystemLookAndFeelClassName());
        if (SystemUtil.IS_WINDOWS && bl && n > 100 && (font = UIManager.getFont("Button.font")) != null) {
            if (stringArray == null) {
                stringArray = InitLAF.getUIPropertyNames();
            }
            int n6 = font.getSize();
            for (String string2 : stringArray) {
                Font font2 = UIManager.getFont(string2);
                if (font2 == null || font2.getSize() >= n6) continue;
                FontUIResource fontUIResource = new FontUIResource(font2.getFamily(), font2.getStyle(), n6);
                UIManager.put(string2, fontUIResource);
            }
        }
    }

    private static String[] getUIPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        for (Object k : uIDefaults.keySet()) {
            String string = k.toString();
            if (string.toLowerCase().indexOf("font") < 0) continue;
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(StringList.EMPTY_LIST);
        if (!StringList.contains(stringArray, "Button.font")) {
            stringArray = StringList.EMPTY_LIST;
        }
        return stringArray;
    }

    public static void configureHTMLContent(int n) {
        if (n < 8 || n > 72) {
            n = 0;
        }
        if (htmlFontSize == null || htmlFontSize != n) {
            Object object;
            Serializable serializable;
            htmlFontSize = n;
            if (n <= 0) {
                serializable = UIManager.getFont("EditorPane.font");
                if (serializable != null) {
                    n = ((Font)serializable).getSize();
                }
                n = Math.max(n, AWTUtil.px(12));
            }
            if (n < 8 || n > 72) {
                return;
            }
            serializable = new StringBuilder("font-size: ");
            ((StringBuilder)serializable).append(Integer.toString(n));
            ((StringBuilder)serializable).append("pt;");
            String string = ((StringBuilder)serializable).toString();
            Object object2 = null;
            URL uRL = InitLAF.class.getResource("html.css");
            if (uRL != null) {
                object = null;
                try {
                    object = URLUtil.loadString(uRL, "UTF-8");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (object != null) {
                    int n2;
                    if (n != 12) {
                        object = InitLAF.scalePx((String)object, (double)n / 12.0);
                    }
                    if ((n2 = ((String)object).indexOf("body {")) >= 0) {
                        serializable = new StringBuilder((String)object);
                        ((StringBuilder)serializable).insert(6, string);
                        object = ((StringBuilder)serializable).toString();
                    }
                    object2 = object;
                }
            }
            if (object2 == null) {
                serializable = new StringBuilder("body { font-family: sans-serif; ");
                ((StringBuilder)serializable).append(string);
                ((StringBuilder)serializable).append(" }");
                object2 = ((StringBuilder)serializable).toString();
            }
            object = (HTMLEditorKit)new JEditorPane().getEditorKitForContentType("text/html");
            ((HTMLEditorKit)object).getStyleSheet().addRule((String)object2);
        }
    }

    private static String scalePx(String string, double d) {
        Pattern pattern = Pattern.compile("(-top:|-bottom:|-left:|-right:)\\s+(\\d+)\\s*;");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            stringBuilder.setLength(0);
            stringBuilder.append(matcher.group(1));
            stringBuilder.append(' ');
            String string2 = matcher.group(2);
            try {
                int n = Integer.parseInt(string2);
                n = (int)Math.rint((double)n * d);
                stringBuilder.append(Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(';');
            matcher.appendReplacement(stringBuffer, stringBuilder.toString());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

