/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.guiutil;

import com.xmlmind.guiutil.ImageTransferable;
import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.ThrowableUtil;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ClipboardHelper {
    private static final boolean reportErrors = System.getProperty("XXE_SHOW_CLIPBOARD_ERRORS") != null;
    private static final Clipboard[] systemClipboard = new Clipboard[1];
    private static final Clipboard[] systemSelection = new Clipboard[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clipboard getSystemClipboard() {
        Clipboard[] clipboardArray = systemClipboard;
        synchronized (systemClipboard) {
            if (systemClipboard[0] == null) {
                Clipboard clipboard = null;
                if (!GraphicsEnvironment.isHeadless()) {
                    clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                }
                if (clipboard == null) {
                    clipboard = new Clipboard("appClipboard");
                }
                ClipboardHelper.systemClipboard[0] = clipboard;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemClipboard[0];
        }
    }

    private static Clipboard systemClipboard(Clipboard clipboard) {
        return clipboard != null ? clipboard : ClipboardHelper.getSystemClipboard();
    }

    public static boolean setString(Clipboard clipboard, String string) {
        return ClipboardHelper.doSetString(ClipboardHelper.systemClipboard(clipboard), string);
    }

    public static boolean hasString(Clipboard clipboard) {
        return ClipboardHelper.hasText(ClipboardHelper.systemClipboard(clipboard), DataFlavor.stringFlavor);
    }

    public static String getString(Clipboard clipboard) {
        return ClipboardHelper.getText(ClipboardHelper.systemClipboard(clipboard), DataFlavor.stringFlavor);
    }

    public static boolean hasHTML(Clipboard clipboard) {
        boolean bl = ClipboardHelper.hasText(ClipboardHelper.systemClipboard(clipboard), DataFlavor.selectionHtmlFlavor);
        return bl;
    }

    public static String getHTML(Clipboard clipboard) {
        String string = ClipboardHelper.getText(ClipboardHelper.systemClipboard(clipboard), DataFlavor.selectionHtmlFlavor);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Clipboard getSystemSelection() {
        Clipboard[] clipboardArray = systemSelection;
        synchronized (systemSelection) {
            if (systemSelection[0] == null) {
                Clipboard clipboard = null;
                if (!GraphicsEnvironment.isHeadless()) {
                    clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
                }
                if (clipboard == null) {
                    clipboard = new Clipboard("appSelection");
                }
                ClipboardHelper.systemSelection[0] = clipboard;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemSelection[0];
        }
    }

    private static Clipboard systemSelection(Clipboard clipboard) {
        return clipboard != null ? clipboard : ClipboardHelper.getSystemSelection();
    }

    public static boolean setSelection(Clipboard clipboard, String string) {
        return ClipboardHelper.doSetString(ClipboardHelper.systemSelection(clipboard), string);
    }

    public static boolean hasSelection(Clipboard clipboard) {
        return ClipboardHelper.hasText(ClipboardHelper.systemSelection(clipboard), DataFlavor.stringFlavor);
    }

    public static String getSelection(Clipboard clipboard) {
        return ClipboardHelper.getText(ClipboardHelper.systemSelection(clipboard), DataFlavor.stringFlavor);
    }

    private static boolean doSetString(Clipboard clipboard, String string) {
        boolean bl = false;
        if (string != null) {
            StringSelection stringSelection = new StringSelection(string);
            try {
                clipboard.setContents(stringSelection, stringSelection);
                bl = true;
            }
            catch (Exception exception) {
                ClipboardHelper.reportError("cannot copy String to clipboard \"" + clipboard.getName() + "\"", exception);
            }
        }
        return bl;
    }

    private static boolean hasText(Clipboard clipboard, DataFlavor dataFlavor) {
        Transferable transferable = null;
        try {
            transferable = clipboard.getContents(ClipboardHelper.class);
        }
        catch (Exception exception) {
            ClipboardHelper.reportError("cannot get data from clipboard \"" + clipboard.getName() + "\"", exception);
        }
        return transferable != null && transferable.isDataFlavorSupported(dataFlavor);
    }

    private static String getText(Clipboard clipboard, DataFlavor dataFlavor) {
        Transferable transferable = null;
        try {
            transferable = clipboard.getContents(ClipboardHelper.class);
        }
        catch (Exception exception) {
            ClipboardHelper.reportError("cannot get data from clipboard \"" + clipboard.getName() + "\"", exception);
        }
        String string = null;
        if (transferable != null) {
            try {
                string = (String)transferable.getTransferData(dataFlavor);
            }
            catch (Exception exception) {
                ClipboardHelper.reportError("cannot get \"" + String.valueOf(dataFlavor) + "\" from clipboard \"" + clipboard.getName() + "\"", exception);
            }
        }
        return string;
    }

    public static boolean setImage(Clipboard clipboard, Image image) {
        boolean bl = false;
        if (image != null) {
            ImageTransferable imageTransferable = new ImageTransferable(image);
            try {
                ClipboardHelper.systemClipboard(clipboard).setContents(imageTransferable, imageTransferable);
                bl = true;
            }
            catch (Exception exception) {
                ClipboardHelper.reportError("cannot copy Image to clipboard \"" + clipboard.getName() + "\"", exception);
            }
        }
        return bl;
    }

    public static boolean hasImage(Clipboard clipboard) {
        Transferable transferable = null;
        try {
            transferable = ClipboardHelper.systemClipboard(clipboard).getContents(ClipboardHelper.class);
        }
        catch (Exception exception) {
            ClipboardHelper.reportError("cannot get data from clipboard \"" + clipboard.getName() + "\"", exception);
        }
        if (transferable != null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (DataFlavor dataFlavor : ImageTransferable.DATA_FLAVORS) {
                if (ArrayUtil.indexOf(dataFlavorArray, dataFlavor) < 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(Clipboard clipboard) {
        Transferable transferable = null;
        try {
            transferable = ClipboardHelper.systemClipboard(clipboard).getContents(ClipboardHelper.class);
        }
        catch (Exception exception) {
            ClipboardHelper.reportError("cannot get data from clipboard \"" + clipboard.getName() + "\"", exception);
        }
        Image image = null;
        if (transferable != null) {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (DataFlavor dataFlavor : ImageTransferable.DATA_FLAVORS) {
                block14: {
                    if (ArrayUtil.indexOf(dataFlavorArray, dataFlavor) < 0) continue;
                    try {
                        if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                            image = (Image)transferable.getTransferData(dataFlavor);
                            break block14;
                        }
                        InputStream inputStream = (InputStream)transferable.getTransferData(dataFlavor);
                        try {
                            image = ClipboardHelper.loadImage(inputStream, dataFlavor);
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Throwable throwable) {
                        ClipboardHelper.reportError("cannot get Image from clipboard \"" + clipboard.getName() + "\"", throwable);
                    }
                }
                if (image != null) break;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Image loadImage(InputStream inputStream, DataFlavor dataFlavor) throws IOException {
        String string = dataFlavor.equals(ImageTransferable.IMAGE_PNG_FLAVOR) ? "png" : (dataFlavor.equals(ImageTransferable.IMAGE_JPEG_FLAVOR) ? "jpeg" : (dataFlavor.equals(ImageTransferable.IMAGE_BMP_FLAVOR) ? "bmp" : dataFlavor.getMimeType()));
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        BufferedImage bufferedImage = null;
        if (imageReader != null) {
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                if (imageInputStream == null) {
                    throw new IOException("cannot create an ImageInputStream out of a java.io.InputStream");
                }
                try {
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    bufferedImage = imageReader.read(0, imageReadParam);
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                imageReader.dispose();
            }
        }
        return bufferedImage;
    }

    public static void reportError(String string, Throwable throwable) {
        if (reportErrors) {
            System.err.println("ClipboardHelper error: " + string + ":\n" + ThrowableUtil.detailedReason(throwable));
        }
    }

    private static void trace(String string) {
        System.err.println("ClipboardHelper>>> " + string);
    }
}

