/*
 * Decompiled with CFR 0.152.
 */
package org.tartarus.snowball;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.tartarus.snowball.Among;

public class SnowballProgram
implements Serializable {
    static final long serialVersionUID = 2016072500L;
    protected StringBuilder current;
    protected int cursor;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected SnowballProgram() {
        this.current = new StringBuilder();
        this.init();
    }

    private void init() {
        this.cursor = 0;
        this.limit = this.current.length();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public void setCurrent(String string) {
        this.current = new StringBuilder(string);
        this.init();
    }

    public String getCurrent() {
        return this.current.toString();
    }

    public SnowballProgram(SnowballProgram snowballProgram) {
        this.current = snowballProgram.current;
        this.cursor = snowballProgram.cursor;
        this.limit = snowballProgram.limit;
        this.limit_backward = snowballProgram.limit_backward;
        this.bra = snowballProgram.bra;
        this.ket = snowballProgram.ket;
    }

    protected void copy_from(SnowballProgram snowballProgram) {
        this.current = snowballProgram.current;
        this.cursor = snowballProgram.cursor;
        this.limit = snowballProgram.limit;
        this.limit_backward = snowballProgram.limit_backward;
        this.bra = snowballProgram.bra;
        this.ket = snowballProgram.ket;
    }

    protected boolean in_grouping(char[] cArray, int n, int n2) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char c = this.current.charAt(this.cursor);
        if (c > n2 || c < n) {
            return false;
        }
        if ((cArray[(c = (char)(c - n)) >> 3] & 1 << (c & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] cArray, int n, int n2) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char c = this.current.charAt(this.cursor - 1);
        if (c > n2 || c < n) {
            return false;
        }
        if ((cArray[(c = (char)(c - n)) >> 3] & 1 << (c & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] cArray, int n, int n2) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char c = this.current.charAt(this.cursor);
        if (c > n2 || c < n) {
            ++this.cursor;
            return true;
        }
        if ((cArray[(c = (char)(c - n)) >> 3] & 1 << (c & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] cArray, int n, int n2) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char c = this.current.charAt(this.cursor - 1);
        if (c > n2 || c < n) {
            --this.cursor;
            return true;
        }
        if ((cArray[(c = (char)(c - n)) >> 3] & 1 << (c & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean eq_s(CharSequence charSequence) {
        if (this.limit - this.cursor < charSequence.length()) {
            return false;
        }
        for (int i = 0; i != charSequence.length(); ++i) {
            if (this.current.charAt(this.cursor + i) == charSequence.charAt(i)) continue;
            return false;
        }
        this.cursor += charSequence.length();
        return true;
    }

    protected boolean eq_s_b(CharSequence charSequence) {
        if (this.cursor - this.limit_backward < charSequence.length()) {
            return false;
        }
        for (int i = 0; i != charSequence.length(); ++i) {
            if (this.current.charAt(this.cursor - charSequence.length() + i) == charSequence.charAt(i)) continue;
            return false;
        }
        this.cursor -= charSequence.length();
        return true;
    }

    protected int find_among(Among[] amongArray) {
        Among among;
        int n;
        int n2 = 0;
        int n3 = amongArray.length;
        int n4 = this.cursor;
        int n5 = this.limit;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        while (true) {
            int n8 = n2 + (n3 - n2 >> 1);
            n = 0;
            int n9 = n6 < n7 ? n6 : n7;
            Among among2 = amongArray[n8];
            for (int i = n9; i < among2.s.length; ++i) {
                if (n4 + n9 == n5) {
                    n = -1;
                    break;
                }
                n = this.current.charAt(n4 + n9) - among2.s[i];
                if (n != 0) break;
                ++n9;
            }
            if (n < 0) {
                n3 = n8;
                n7 = n9;
            } else {
                n2 = n8;
                n6 = n9;
            }
            if (n3 - n2 > 1) continue;
            if (n2 > 0 || n3 == n2 || bl) break;
            bl = true;
        }
        do {
            among = amongArray[n2];
            if (n6 < among.s.length) continue;
            this.cursor = n4 + among.s.length;
            if (among.method == null) {
                return among.result;
            }
            try {
                Object object = among.method.invoke((Object)this, new Object[0]);
                n = object.toString().equals("true") ? 1 : 0;
            }
            catch (InvocationTargetException invocationTargetException) {
                n = 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                n = 0;
            }
            this.cursor = n4 + among.s.length;
            if (n == 0) continue;
            return among.result;
        } while ((n2 = among.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] amongArray) {
        Among among;
        int n;
        int n2 = 0;
        int n3 = amongArray.length;
        int n4 = this.cursor;
        int n5 = this.limit_backward;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        while (true) {
            int n8 = n2 + (n3 - n2 >> 1);
            n = 0;
            int n9 = n6 < n7 ? n6 : n7;
            Among among2 = amongArray[n8];
            for (int i = among2.s.length - 1 - n9; i >= 0; --i) {
                if (n4 - n9 == n5) {
                    n = -1;
                    break;
                }
                n = this.current.charAt(n4 - 1 - n9) - among2.s[i];
                if (n != 0) break;
                ++n9;
            }
            if (n < 0) {
                n3 = n8;
                n7 = n9;
            } else {
                n2 = n8;
                n6 = n9;
            }
            if (n3 - n2 > 1) continue;
            if (n2 > 0 || n3 == n2 || bl) break;
            bl = true;
        }
        do {
            among = amongArray[n2];
            if (n6 < among.s.length) continue;
            this.cursor = n4 - among.s.length;
            if (among.method == null) {
                return among.result;
            }
            try {
                Object object = among.method.invoke((Object)this, new Object[0]);
                n = object.toString().equals("true") ? 1 : 0;
            }
            catch (InvocationTargetException invocationTargetException) {
                n = 0;
            }
            catch (IllegalAccessException illegalAccessException) {
                n = 0;
            }
            this.cursor = n4 - among.s.length;
            if (n == 0) continue;
            return among.result;
        } while ((n2 = among.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int n, int n2, String string) {
        int n3 = string.length() - (n2 - n);
        this.current.replace(n, n2, string);
        this.limit += n3;
        if (this.cursor >= n2) {
            this.cursor += n3;
        } else if (this.cursor > n) {
            this.cursor = n;
        }
        return n3;
    }

    protected void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit || this.limit > this.current.length()) {
            System.err.println("faulty slice operation");
        }
    }

    protected void slice_from(String string) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, string);
    }

    protected void slice_from(CharSequence charSequence) {
        this.slice_from(charSequence.toString());
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int n, int n2, String string) {
        int n3 = this.replace_s(n, n2, string);
        if (n <= this.bra) {
            this.bra += n3;
        }
        if (n <= this.ket) {
            this.ket += n3;
        }
    }

    protected void insert(int n, int n2, CharSequence charSequence) {
        this.insert(n, n2, charSequence.toString());
    }

    protected void slice_to(StringBuilder stringBuilder) {
        this.slice_check();
        stringBuilder.replace(0, stringBuilder.length(), this.current.substring(this.bra, this.ket));
    }

    protected void assign_to(StringBuilder stringBuilder) {
        stringBuilder.replace(0, stringBuilder.length(), this.current.substring(0, this.limit));
    }
}

