/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.util.StringList;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x.processor.Plugin;
import com.xmlmind.w2x.processor.Processor;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.load.LoadDocument;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

final class OutputFormat {
    public static final Option[] NO_OPTIONS = new Option[0];
    public final String name;
    public final String category;
    public final String subCategory;
    public final Option[] options;
    public final boolean hasStyleMapping;
    public final String stylesheetTemplate;
    public final String ruleTemplate;
    public final Namespace targetNamespace;
    private static OutputFormat[] outputFormats;
    private static HashMap<String, String[]> subCategories;
    private static String[] categories;
    private static final String OTHER_CATEGORY;
    private static final Name CATEGORY_NAME;
    private static final Name DEFAULT_NAME;
    private static final Name HINT_NAME;
    private static final Name LABEL_NAME;
    private static final Name NAME_NAME;
    private static final Name OPTIONS_NAME;
    private static final Name OPTION_NAME;
    private static final Name OUPUT_FORMAT_NAME;
    private static final Name PARAMETER_NAME;
    private static final Name STYLE_MAPPING_NAME;
    private static final Name SUB_CATEGORY_NAME;
    private static final Name TRANSFORM_NAME;
    private static final Name TYPE_NAME;

    public OutputFormat(String string, String string2, String string3, Option[] optionArray, boolean bl, String string4, String string5, Namespace namespace) {
        this.name = string;
        this.category = string2;
        this.subCategory = string3;
        this.options = optionArray;
        this.hasStyleMapping = bl;
        this.stylesheetTemplate = string4;
        this.ruleTemplate = string5;
        this.targetNamespace = namespace;
    }

    public Option getOption(String string) {
        if (this.options != null) {
            for (Option option : this.options) {
                if (!option.name.equals(string)) continue;
                return option;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("OutputFormat name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", category=");
        stringBuilder.append(this.category);
        stringBuilder.append(", subCategory=");
        stringBuilder.append(this.subCategory);
        stringBuilder.append('\n');
        for (Option option : this.options) {
            stringBuilder.append("    ");
            option.toString(stringBuilder);
            stringBuilder.append('\n');
        }
        if (this.hasStyleMapping) {
            stringBuilder.append("    hasStyleMapping=true\n");
            if (this.stylesheetTemplate != null) {
                stringBuilder.append("    stylesheetTemplate={\n");
                stringBuilder.append(this.stylesheetTemplate);
                stringBuilder.append("\n    }\n");
            }
            if (this.ruleTemplate != null) {
                stringBuilder.append("    ruleTemplate={\n");
                stringBuilder.append(this.ruleTemplate);
                stringBuilder.append("\n    }\n");
            }
            if (this.targetNamespace != null) {
                stringBuilder.append("    targetNamespace=\"");
                stringBuilder.append(this.targetNamespace.uri);
                stringBuilder.append("\"\n");
            }
        }
    }

    public static String[] getCategories() {
        OutputFormat.loadAll();
        return categories;
    }

    public static String[] getSubCategories(String string) {
        OutputFormat.loadAll();
        return subCategories.get(string);
    }

    public static OutputFormat get(String string, String string2) {
        OutputFormat.loadAll();
        for (OutputFormat outputFormat : outputFormats) {
            if (!outputFormat.category.equals(string) || !outputFormat.subCategory.equals(string2)) continue;
            return outputFormat;
        }
        return null;
    }

    public static OutputFormat get(String string) {
        OutputFormat.loadAll();
        for (OutputFormat outputFormat : outputFormats) {
            if (!outputFormat.name.equals(string)) continue;
            return outputFormat;
        }
        return null;
    }

    public static String allToString() {
        OutputFormat.loadAll();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---\n");
        for (OutputFormat outputFormat : outputFormats) {
            outputFormat.toString(stringBuilder);
            stringBuilder.append('\n');
        }
        stringBuilder.append("---\n");
        return stringBuilder.toString();
    }

    private static void loadAll() {
        if (outputFormats != null) {
            return;
        }
        ArrayList<OutputFormat> arrayList = new ArrayList<OutputFormat>();
        try {
            OutputFormat.loadOutputFormats(arrayList);
        }
        catch (Exception exception) {
            System.err.println("internal error: cannot load output formats: " + ThrowableUtil.reason(exception));
        }
        OutputFormat.addPlugins(arrayList);
        outputFormats = new OutputFormat[arrayList.size()];
        arrayList.toArray(outputFormats);
        subCategories = new HashMap();
        for (OutputFormat outputFormat : outputFormats) {
            String[] stringArray = subCategories.get(outputFormat.category);
            stringArray = stringArray == null ? new String[]{outputFormat.subCategory} : StringList.append(stringArray, outputFormat.subCategory);
            subCategories.put(outputFormat.category, stringArray);
        }
        for (Object[] objectArray : subCategories.values()) {
            Arrays.sort(objectArray);
        }
        categories = subCategories.keySet().toArray(StringList.EMPTY_LIST);
        Arrays.sort(categories, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (string == OTHER_CATEGORY) {
                    return 1;
                }
                if (string2 == OTHER_CATEGORY) {
                    return -1;
                }
                return string.compareTo(string2);
            }
        });
    }

    private static void addPlugins(List<OutputFormat> list) {
        Plugin[] pluginArray;
        int n = list.size();
        for (Plugin plugin : pluginArray = Processor.getPlugins()) {
            int n2;
            String string = plugin.outputDescription;
            if (string == null) {
                string = plugin.name;
            }
            String string2 = OTHER_CATEGORY;
            boolean bl = false;
            String string3 = null;
            String string4 = null;
            Namespace namespace = null;
            String string5 = null;
            String[] stringArray = plugin.w2xArguments;
            if (stringArray != null) {
                n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (!"-o".equals(stringArray[i])) continue;
                    if (i + 1 >= n2) break;
                    string5 = stringArray[i + 1];
                    break;
                }
            }
            if (string5 != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    OutputFormat outputFormat = list.get(n2);
                    if (!outputFormat.name.equals(string5)) continue;
                    if (!outputFormat.subCategory.equals(string)) {
                        string2 = outputFormat.category;
                    }
                    bl = outputFormat.hasStyleMapping;
                    string3 = outputFormat.stylesheetTemplate;
                    string4 = outputFormat.ruleTemplate;
                    namespace = outputFormat.targetNamespace;
                    break;
                }
            }
            OutputFormat outputFormat = new OutputFormat(plugin.name, string2, string, NO_OPTIONS, bl, string3, string4, namespace);
            list.add(outputFormat);
        }
    }

    private static void loadOutputFormats(List<OutputFormat> list) throws Exception {
        URL uRL = OutputFormat.class.getResource("output_formats.xml");
        if (uRL == null) {
            throw new RuntimeException("did not find resource 'output_formats.xml'");
        }
        Document document = LoadDocument.load(uRL, 8192, null, null, null);
        Element element = document.getRootElement();
        if (element.getName() != Name.get("ouputFormats")) {
            throw new RuntimeException("expected a 'ouputFormats' root element; got '" + String.valueOf(element.getName()) + "'");
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || ((Element)node).getName() != OUPUT_FORMAT_NAME) continue;
            list.add(OutputFormat.loadOutputFormat((Element)node));
        }
    }

    private static OutputFormat loadOutputFormat(Element element) throws Exception {
        String string = element.getNmtokenAttribute(NAME_NAME, null);
        if (string == null) {
            throw new RuntimeException("missing or invalid 'name' attribute");
        }
        String string2 = element.getTokenAttribute(CATEGORY_NAME, null);
        if (string2 == null || string2.length() == 0) {
            throw new RuntimeException("missing or invalid 'category' attribute");
        }
        String string3 = element.getTokenAttribute(SUB_CATEGORY_NAME, null);
        if (string3 == null || string3.length() == 0) {
            throw new RuntimeException("missing or invalid 'subCategory' attribute");
        }
        Option[] optionArray = null;
        boolean bl = false;
        String string4 = null;
        String string5 = null;
        Namespace namespace = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            int n;
            Object object;
            Serializable serializable;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == OPTIONS_NAME) {
                serializable = new ArrayList();
                for (object = element2.getFirstChild(); object != null; object = ((Node)object).getNextSibling()) {
                    if (((Node)object).getType() != Node.Type.ELEMENT || ((Element)object).getName() != OPTION_NAME) continue;
                    ((ArrayList)serializable).add(OutputFormat.loadOption((Element)object));
                }
                optionArray = new Option[((ArrayList)serializable).size()];
                ((ArrayList)serializable).toArray(optionArray);
                continue;
            }
            if (name != STYLE_MAPPING_NAME) continue;
            bl = true;
            serializable = element2.getChildElement(0);
            if (serializable == null || ((Element)serializable).getName() != TRANSFORM_NAME || (object = ((Element)serializable).getText()) == null) continue;
            object = ((String)object).trim();
            namespace = OutputFormat.parseTargetNamespace((String)object);
            int n2 = ((String)object).indexOf("<xsl:template");
            if (n2 <= 0 || (n = ((String)object).indexOf("</xsl:template>", n2 + 13)) <= 0) continue;
            string5 = ((String)object).substring(n2, n += 15);
            int n3 = ((String)object).indexOf(10, n);
            if (n3 > 0) {
                n = n3 + 1;
            }
            string4 = new StringBuilder((String)object).delete(n2, n).toString();
        }
        if (optionArray == null || optionArray.length == 0) {
            throw new RuntimeException("missing or invalid 'options' element");
        }
        return new OutputFormat(string, string2, string3, optionArray, bl, string4, string5, namespace);
    }

    private static Option loadOption(Element element) throws Exception {
        String string;
        String string2;
        String string3 = element.getNmtokenAttribute(NAME_NAME, null);
        if (string3 == null) {
            throw new RuntimeException("missing or invalid 'name' attribute");
        }
        String string4 = element.getTokenAttribute(LABEL_NAME, null);
        if (string4 == null || string4.length() == 0) {
            throw new RuntimeException("missing or invalid 'label' attribute");
        }
        String string5 = element.getTokenAttribute(HINT_NAME, null);
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        OptionType optionType = null;
        String[] stringArray = null;
        String string6 = element.getTokenAttribute(TYPE_NAME, null);
        if (string6 == null || string6.length() == 0) {
            throw new RuntimeException("missing or invalid 'type' attribute");
        }
        if (string6.indexOf(124) > 0) {
            optionType = OptionType.ENUMERATED_VALUES;
            stringArray = StringUtil.split(string6, '|');
            if (stringArray.length < 2) {
                throw new RuntimeException("'" + string6 + "', invalid 'type' attribute");
            }
            if (stringArray.length == 2 && "no".equals(stringArray[0]) && "yes".equals(stringArray[1])) {
                stringArray = null;
                optionType = OptionType.YES_NO;
            }
        } else if ("OpenFilePath".equals(string6)) {
            optionType = OptionType.OPEN_FILE_PATH;
        } else if ("SaveFileURI".equals(string6)) {
            optionType = OptionType.SAVE_FILE_URI;
        } else if ("SaveDirectoryURI".equals(string6)) {
            optionType = OptionType.SAVE_DIRECTORY_URI;
        } else if ("String".equals(string6)) {
            optionType = OptionType.STRING;
        } else if ("ID".equals(string6)) {
            optionType = OptionType.ID;
        } else {
            throw new RuntimeException("'" + string6 + "', unknown option type");
        }
        if ((string2 = element.getTokenAttribute(DEFAULT_NAME, null)) != null && string2.length() == 0) {
            string2 = null;
        }
        if ((string = element.getTokenAttribute(PARAMETER_NAME, null)) == null || string.length() == 0) {
            throw new RuntimeException("missing or invalid 'parameter' attribute");
        }
        return new Option(string3, string4, string5, optionType, stringArray, string2, string);
    }

    private static Namespace parseTargetNamespace(String string) {
        Namespace namespace = Namespace.NONE;
        int n = string.indexOf("<xsl:stylesheet");
        if (n > 0) {
            int n2 = string.indexOf(62, n += 15);
            if (n2 > 0) {
                string = string.substring(n, n2);
            }
            if ((n = string.indexOf("xmlns=\"")) > 0 && (n2 = string.indexOf(34, n += 7)) > 0) {
                namespace = Namespace.get(string.substring(n, n2));
            }
        }
        return namespace;
    }

    static {
        OTHER_CATEGORY = Msg.msg("otherCategory");
        CATEGORY_NAME = Name.get("category");
        DEFAULT_NAME = Name.get("default");
        HINT_NAME = Name.get("hint");
        LABEL_NAME = Name.get("label");
        NAME_NAME = Name.get("name");
        OPTIONS_NAME = Name.get("options");
        OPTION_NAME = Name.get("option");
        OUPUT_FORMAT_NAME = Name.get("ouputFormat");
        PARAMETER_NAME = Name.get("parameter");
        STYLE_MAPPING_NAME = Name.get("styleMapping");
        SUB_CATEGORY_NAME = Name.get("subCategory");
        TRANSFORM_NAME = Name.get("transform");
        TYPE_NAME = Name.get("type");
    }

    public static final class Option {
        public final String name;
        public final String label;
        public final String hint;
        public final OptionType type;
        public final String[] enumeratedValues;
        public final String defaultValue;
        public final String parameterTemplate;

        public Option(String string, String string2, String string3, OptionType optionType, String[] stringArray, String string4, String string5) {
            this.name = string;
            this.label = string2;
            this.hint = string3;
            this.type = optionType;
            this.enumeratedValues = stringArray;
            this.defaultValue = string4;
            this.parameterTemplate = string5;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toString(stringBuilder);
            return stringBuilder.toString();
        }

        public void toString(StringBuilder stringBuilder) {
            stringBuilder.append("Option name=");
            stringBuilder.append(this.name);
            stringBuilder.append(", label=");
            stringBuilder.append(this.label);
            if (this.hint != null) {
                stringBuilder.append(", hint=");
                stringBuilder.append(this.hint);
            }
            stringBuilder.append(", type=");
            stringBuilder.append((Object)this.type);
            if (this.enumeratedValues != null) {
                stringBuilder.append(", enumeratedValues=");
                stringBuilder.append(StringUtil.join('|', this.enumeratedValues));
            }
            if (this.defaultValue != null) {
                stringBuilder.append(", defaultValue=");
                stringBuilder.append(this.defaultValue);
            }
            stringBuilder.append(", parameterTemplate=");
            stringBuilder.append(this.parameterTemplate);
        }
    }

    public static enum OptionType {
        STRING,
        ID,
        YES_NO,
        ENUMERATED_VALUES,
        OPEN_FILE_PATH,
        SAVE_FILE_URI,
        SAVE_DIRECTORY_URI;

    }
}

