/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.w2x_app.App;
import java.awt.Desktop;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class DesktopIntegration
implements InvocationHandler {
    private final App app;
    private String envClassNamePrefix;
    private Method cancelQuitMethod;
    private static Boolean debug;

    public DesktopIntegration(App app) {
        Object object;
        this.app = app;
        if (debug == null) {
            debug = Boolean.FALSE;
            try {
                if (System.getenv("W2X_DEBUG_DESKTOP") != null || System.getProperty("W2X_DEBUG_DESKTOP") != null) {
                    debug = Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.envClassNamePrefix = null;
        Class clazz = null;
        Object object2 = null;
        try {
            if (SystemUtil.javaVersionNumber().compareTo(SystemUtil.JAVA_9_0_0) >= 0) {
                if (Desktop.isDesktopSupported()) {
                    this.envClassNamePrefix = "java.awt.desktop.";
                    clazz = Desktop.class;
                    object2 = Desktop.getDesktop();
                }
            } else if (SystemUtil.IS_MAC_OS) {
                this.envClassNamePrefix = "com.apple.eawt.";
                clazz = Class.forName("com.apple.eawt.Application");
                object = clazz.getMethod("getApplication", new Class[0]);
                object2 = ((Method)object).invoke(null, new Object[0]);
            }
            DesktopIntegration.debug("envClass=" + String.valueOf(clazz));
        }
        catch (Throwable throwable) {
            DesktopIntegration.error("No desktop integration object:\n" + ThrowableUtil.detailedReason(throwable));
        }
        if (object2 == null) {
            return;
        }
        object = new Method[2];
        Object object3 = null;
        try {
            Object object4 = Class.forName(this.envClassNamePrefix + "AboutHandler");
            object[0] = clazz.getMethod("setAboutHandler", new Class[]{object4});
            Class<?> clazz2 = Class.forName(this.envClassNamePrefix + "QuitHandler");
            object[1] = clazz.getMethod("setQuitHandler", clazz2);
            object3 = Proxy.newProxyInstance(DesktopIntegration.class.getClassLoader(), new Class[]{object4, clazz2}, (InvocationHandler)this);
        }
        catch (Throwable throwable) {
            DesktopIntegration.error("incompatible desktop integration object:\n" + ThrowableUtil.detailedReason(throwable));
        }
        for (Object object5 : object) {
            try {
                ((Method)object5).invoke(object2, object3);
            }
            catch (Throwable throwable) {
                DesktopIntegration.error("failed to invoke method '" + ((Method)object5).getName() + "':\n" + ThrowableUtil.detailedReason(throwable));
            }
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        DesktopIntegration.debug("invoke " + string);
        if ("handleAbout".equals(string)) {
            if (objectArray != null && objectArray.length == 1) {
                this.handleAbout(objectArray[0]);
            }
        } else if ("handleQuitRequestWith".equals(string) && objectArray != null && objectArray.length == 2) {
            this.handleQuit(objectArray[0], objectArray[1]);
        }
        return null;
    }

    private void handleAbout(Object object) {
        DesktopIntegration.debug("handleAbout " + String.valueOf(object));
        this.app.about();
    }

    private void handleQuit(Object object, Object object2) {
        DesktopIntegration.debug("handleQuit " + String.valueOf(object) + " " + String.valueOf(object2));
        this.app.quit();
        Method method = this.cancelQuitMethod();
        if (method != null) {
            DesktopIntegration.invokeMethod(method, object2);
        }
    }

    private Method cancelQuitMethod() {
        if (this.cancelQuitMethod == null) {
            this.cancelQuitMethod = DesktopIntegration.getMethod(this.envClassNamePrefix + "QuitResponse", "cancelQuit");
        }
        return this.cancelQuitMethod;
    }

    private static Method getMethod(String string, String string2) {
        Method method = null;
        try {
            Class<?> clazz = Class.forName(string);
            method = clazz.getMethod(string2, new Class[0]);
        }
        catch (Throwable throwable) {
            DesktopIntegration.error("Cannot get method " + string + "." + string2 + ":\n" + ThrowableUtil.detailedReason(throwable));
        }
        return method;
    }

    private static Object invokeMethod(Method method, Object object) {
        Object object2 = null;
        try {
            object2 = method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            DesktopIntegration.error("Cannot invoke method " + method.getDeclaringClass().getName() + "." + method.getName() + ":\n" + ThrowableUtil.detailedReason(throwable));
        }
        return object2;
    }

    private static void debug(String string) {
        if (debug == Boolean.TRUE) {
            System.err.println("Desktop Integration: DEBUG: " + string);
        }
    }

    private static void error(String string) {
        System.err.println("Desktop Integration: ERROR: " + string);
    }
}

