/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.w2x_app;

import com.xmlmind.guiutil.DialogUtil;
import com.xmlmind.guiutil.IconResource;
import com.xmlmind.guiutil.ImageResource;
import com.xmlmind.guiutil.InitLAF;
import com.xmlmind.jhelp.JHelp;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.Preferences;
import com.xmlmind.util.StringList;
import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.w2x.docx.toxhtml.Product;
import com.xmlmind.w2x.processor.Main;
import com.xmlmind.w2x_app.Conversion;
import com.xmlmind.w2x_app.ConversionStatus;
import com.xmlmind.w2x_app.ConvertPane;
import com.xmlmind.w2x_app.DesktopIntegration;
import com.xmlmind.w2x_app.Msg;
import com.xmlmind.w2x_app.Start;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public final class App
implements ActionListener,
ConvertPane.Owner {
    private File installDirectory;
    private String[] searchPluginErrors;
    private URL[] pluginURLs;
    private File preferencesFile;
    private Preferences preferences;
    private JFrame frame;
    private ConvertPane convertPane;
    private JButton quitButton;

    public static void main(String[] stringArray) {
        new App().run(stringArray);
    }

    public App() {
        this(null);
    }

    public App(Map<String, Object> map) {
        if (map != null) {
            this.installDirectory = (File)map.get("installDirectory");
            this.searchPluginErrors = (String[])map.get("searchPluginErrors");
            this.pluginURLs = (URL[])map.get("pluginURLs");
        } else {
            this.installDirectory = Start.findInstallDir();
            this.searchPluginErrors = StringList.EMPTY_LIST;
            this.pluginURLs = URLUtil.EMPTY_LIST;
        }
    }

    public void run(String[] stringArray) {
        Object object;
        Thread.currentThread().setContextClassLoader(App.class.getClassLoader());
        Main.initResolver(this.installDirectory);
        Main.initPlugins(this.searchPluginErrors, this.pluginURLs);
        this.initPreferences();
        boolean bl = false;
        File file = null;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            object = stringArray[i];
            if ("-vv".equals(object)) {
                bl = true;
                continue;
            }
            if ("-putpref".equals(object)) {
                if (i + 2 >= n) {
                    App.usage(null);
                }
                this.preferences.putString(stringArray[i + 1], stringArray[i + 2]);
                i += 2;
                continue;
            }
            if ("-delpref".equals(object)) {
                if (i + 1 >= n) {
                    App.usage(null);
                }
                this.preferences.remove(stringArray[++i]);
                continue;
            }
            if (((String)object).startsWith("-")) {
                App.usage("\"" + (String)object + "\", unknown option");
            }
            if ((file = new File(stringArray[i])).isFile() && "docx".equalsIgnoreCase(FileUtil.getExtension(file))) continue;
            App.usage("\"" + stringArray[i] + "\", not a DOCX file");
        }
        this.createUI(bl);
        this.showUI();
        final File file2 = file;
        object = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                App.this.addPlatformDependentSupport();
                App.this.initUI();
                if (file2 != null) {
                    App.this.convertPane.setInputFile(file2);
                }
            }
        });
        ((Timer)object).setRepeats(false);
        ((Timer)object).start();
    }

    private static void usage(String string) {
        if (string != null) {
            System.err.println("w2x-app: ERROR: " + string);
        }
        System.err.println("Usage: w2x-app [Advanced options] [input_docx_file]\nAdvanced options are:\n  -vv                   Show debug messages.\n  -putpref key value    Set specified preference.\n  -delpref key          Unset specified preference.\n");
        System.exit(1);
    }

    private void initPreferences() {
        File file = SystemUtil.userPreferencesDir();
        if (!file.isDirectory()) {
            FileUtil.doDeleteFileOrDir(file);
            if (!file.mkdirs()) {
                file = null;
            }
        }
        this.preferences = new Preferences();
        this.preferencesFile = null;
        if (file != null) {
            this.preferencesFile = new File(file, "w2x-app.properties");
        }
        if (this.preferencesFile != null) {
            this.preferences.load(this.preferencesFile);
        }
        Preferences.setUserPreferences(this.preferences);
    }

    private void createUI(boolean bl) {
        InitLAF.init(this.preferences, null);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(toolTipManager.getDismissDelay() * 2);
        this.frame = new JFrame(Product.getFullName());
        this.frame.setIconImage(ImageResource.get(App.class, "app.png"));
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                App.this.quit();
            }
        });
        this.initHelp();
        JPanel jPanel = (JPanel)this.frame.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        this.convertPane = this.createConvertPane(bl);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.convertPane, DialogUtil.px(gridBagConstraints));
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jSeparator, DialogUtil.px(gridBagConstraints));
        Component component = DialogUtil.pxHorizontalStrut(50);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add(component, DialogUtil.px(gridBagConstraints));
        IconResource iconResource = new IconResource(App.class, "help.png");
        JButton jButton = new JButton(iconResource);
        jButton.setDisabledIcon(iconResource);
        DialogUtil.setHelpText(jButton);
        JHelp.configureHelpButton(jButton, "converting_docx_to_xml");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jButton, DialogUtil.px(gridBagConstraints));
        String string = Msg.msg("quit");
        iconResource = new IconResource(App.class, "quit.png");
        this.quitButton = new JButton(DialogUtil.buttonLabel(string), iconResource);
        this.quitButton.setDisabledIcon(iconResource);
        DialogUtil.setMnemonic(this.quitButton, string);
        this.quitButton.addActionListener(this);
        this.quitButton.setActionCommand("quit");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.quitButton, DialogUtil.px(gridBagConstraints));
        this.frame.pack();
    }

    private void initHelp() {
        File file;
        URL uRL = App.class.getResource("/w2x_app_cshelp.xml");
        if (uRL == null) {
            return;
        }
        URI uRI = null;
        if (this.installDirectory != null && (file = new File(this.installDirectory, "doc" + File.separator + "index.html")).isFile()) {
            uRI = FileUtil.fileToURI(file);
        } else {
            try {
                uRI = new URI("http://www.xmlmind.com/w2x/_distrib/doc/index.html");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (uRI == null) {
            return;
        }
        JHelp.initialize(null, uRI, null);
        JHelp.addIdMap(uRL);
    }

    private ConvertPane createConvertPane(boolean bl) {
        ConvertPane convertPane = new ConvertPane(this.installDirectory, true);
        convertPane.setDebug(bl);
        convertPane.setOwner(this);
        return convertPane;
    }

    private void showUI() {
        Rectangle rectangle = new Rectangle(0, 0, this.frame.getWidth(), this.frame.getHeight());
        Rectangle rectangle2 = this.preferences.getRectangle("geometry", rectangle);
        Rectangle rectangle3 = this.frame.getGraphicsConfiguration().getBounds();
        if (rectangle2.width <= 0) {
            rectangle2.width = rectangle.width;
        }
        if (rectangle2.width > rectangle3.width) {
            rectangle2.width = rectangle3.width;
        }
        if (rectangle2.height <= 0) {
            rectangle2.height = rectangle.height;
        }
        if (rectangle2.height > rectangle3.height) {
            rectangle2.height = rectangle3.height;
        }
        if (rectangle2.x < rectangle3.x) {
            rectangle2.x = rectangle3.x;
        } else if (rectangle2.x + rectangle2.width > rectangle3.x + rectangle3.width) {
            rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
        }
        if (rectangle2.y < rectangle3.y) {
            rectangle2.y = rectangle3.y;
        } else if (rectangle2.y + rectangle2.height > rectangle3.y + rectangle3.height) {
            rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
        }
        this.frame.setBounds(rectangle2);
        this.preferences.putRectangle("geometry", rectangle2);
        this.frame.setVisible(true);
    }

    private void addPlatformDependentSupport() {
        if (SystemUtil.IS_MAC_OS) {
            new DesktopIntegration(this);
        }
    }

    private void initUI() {
        this.convertPane.loadPreferences(this.preferences);
        this.convertPane.focusPane();
    }

    @Override
    public boolean canConvert(Conversion conversion, File file, File file2) {
        return true;
    }

    @Override
    public void beginConvert(Conversion conversion, File file, File file2) {
        this.quitButton.setEnabled(false);
    }

    @Override
    public void endConvert(Conversion conversion, File file, File file2, ConversionStatus conversionStatus) {
        this.quitButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("about")) {
            this.about();
        } else if (string.equals("quit")) {
            if ((actionEvent.getModifiers() & 1) != 0) {
                this.about();
            } else {
                this.quit();
            }
        }
    }

    void about() {
        IconResource iconResource = new IconResource(App.class, "logo.png");
        JOptionPane.showMessageDialog(this.frame, Msg.msg("about.message", Product.getFullName(), Integer.toString(2025)), Msg.msg("about.title", "XMLmind Word To XML"), -1, iconResource);
    }

    void quit() {
        if (!this.quitButton.isEnabled()) {
            return;
        }
        this.savePreferences();
        System.exit(0);
    }

    private void savePreferences() {
        if (this.frame.getExtendedState() == 0) {
            this.preferences.putRectangle("geometry", this.frame.getBounds());
        }
        this.convertPane.savePreferences(this.preferences);
        if (this.preferencesFile != null) {
            this.preferences.save(this.preferencesFile, Product.getFullName());
        }
    }
}

